%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This is a class for LaTeX2e that should format a report as per JNTUA Thesis guidelines.
% The page layout is set using the geometry package.  The double/singlespacing is setup using setspace.
% Figure captions are set using the hang option  caption2.  natbib is used to do the citation using an
% author-year format. I've made an jntua.bst file that formats the references as per the JNTUA guidelines.
%
% To use this class do the following:
%  \documentclass[options]{jntua}
%
% Options:
%
%   thesis, MS -- generates the appropriate title page and loads the report class.
%
%   synopsis, presubsynopsis -- Generates the title page for the synopsis or presubsynopsis.  This also
%   loads the article class instead of the report.
%
% Example:
% \documentclass[thesis]{jntua}
% \documentclass[synopsis]{jntua}
% \documentclass[presubsynopsis]{jntua}
% \documentclass[MS]{jntua}
%
% IMPORTANT NOTICE:
%
%   PLEASE DO NOT MESS WITH THE MARGINS AND GENERAL FORMATTING SETUP
%   IN THIS FILE UNLESS YOU ARE ABSOLUTELY SURE THAT THE FORMAT DOES NOT
%   MATCH WITH THE THESIS GUIDELINES.  FOR EXAMPLE, DO NOT CHANGE THE
%   MARGINS AND SPACING JUST TO MAKE YOUR THESIS LARGER!
%
% Notes:
%
%   * I am using as much of the Thesis guidelines for the spacing
%     and margins as I can.
%   * This class will assume a4paper with 12pt fonts.
%
% This class file prepared by
% Dr.E.KESHVA REDDY, Professor
% Department of Mathematics
% JAWAHARLAL NEHRU TECHNOLOGICAL UNIVERSITY ANANTAPUR
% College of Engineering
% Ananthapuramu-515002
% March 2016.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\NeedsTeXFormat{LaTeX2e}

\ProvidesClass{jntua}[2016/03/02 JNTUA-Anantapur Thesis]

\newif\if@Thesis
\newif\if@Synopsis
\newif\if@PreSubSynopsis
\newif\if@MS



\DeclareOption{thesis}{\@Thesistrue}
\DeclareOption{synopsis}{\@Synopsistrue}
\DeclareOption{presubsynopsis}{\@PreSubSynopsistrue}
\DeclareOption{MS}{\@MStrue}
\ProcessOptions\relax

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  Load the correct class.
\if@Synopsis
    \LoadClass[12pt,a4paper]{report}
\else
\if@PreSubSynopsis
     \LoadClass[12pt,a4paper]{report}
\else
    \LoadClass[12pt,a4paper]{report}
\fi
\fi
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Geometry and page layout
\RequirePackage[a4paper,left=1in,right=1in,top=1in,bottom=1in,nohead]{geometry}
\parskip 8pt

\renewcommand{\@pnumwidth}{2.5em}
%\renewcommand{\@tocrmarg}{2.5em}


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Using setspace to do the single/double spacing.  Setspace also
%% makes all tables and figures have single spacing automatically.
\RequirePackage{setspace}
\RequirePackage{atbeginend} % used to redefine the list environs
\setstretch{1.5}

\BeforeBegin{itemize}{\vspace*{-5ex}\begin{singlespace}}
\AfterEnd{itemize}{\end{singlespace}}

\BeforeBegin{enumerate}{\vspace*{-5ex}\begin{singlespace}}
\AfterEnd{enumerate}{\end{singlespace}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% The figure captioning is done correctly via the hang option.
%%\RequirePackage[hang]{caption2}  -> TeX generates error
\RequirePackage[hang]{caption}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Bibliography
%
% natbib allows easy switching of citation style and using it along
% with the jntua.bst makes things perfect.
%\RequirePackage[round, sort, compress, authoryear]{natbib}
%\RequirePackage[numbers,square]{natbib}
%\bibliographystyle{jntua}

%\newcommand{\bibstyle@jntua}{\bibpunct{(}{)}{;}{a}{,}{,}%
%     \gdef\NAT@biblabel##1{##1. }}
%
%\setlength{\bibhang}{0pt}
%\citestyle{jntua}
%\citestyle{unsrt_newen}


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Other useful macros.  Many of these are modifications from newdiss.cls

% \department{department name} -- user macro to declare name of department.
\def\department#1{\gdef\@department{#1}}
\def\registerno#1{\gdef\@registerno{#1}}
\def\supervisor#1{\gdef\@supervisor{#1}}
\def\cosupervisor#1{\gdef\@cosupervisor{#1}}
%\RequirePackage[dvips]{graphicx}


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% The title page

\def\maketitle{%
  \pagenumbering{roman}
  \thispagestyle{empty}
  \newpage
  \null
  \setcounter{page}{0}
  \parskip=0pt
  \begin{center}%
  \let \footnote \thanks
  \vglue 0in % this makes top margin 2in
  \vskip -5ex%
{\color{navyblue}
\if@PreSubSynopsis
  { \footnotesize \bf Pre-Submission Seminar \par}

    { \bf Synopsis of the Thesis \par}


    {\large \bf \singlespacing \@title \par}
    \vskip 2ex%

    {\bf Submitted in the partial fulfillment of the requirements for \par}

    {\bf The award of the degree of \par}
    \vskip 4ex%
    {\large \bf DOCTOR OF PHILOSOPHY \par}
\else
\if@Synopsis
   {\large \bf \singlespacing \@title \par}
    \vskip 2ex%

    { A Synopsis submitted to \par}

    { Jawaharlal Nehru Technological University Anantapur \par}
    \vskip 2ex%
    { \em For award of the degree of \par}
    \vskip 2ex%
    {\large \bf DOCTOR OF PHILOSOPHY \par}
\else
\if@Thesis
    {\large \bf \singlespacing \@title \par}
    \vskip 2ex%

    { A Thesis submitted to \par}

    { Jawaharlal Nehru Technological University Anantapur \par}
    \vskip 2ex%
    { \em For award of the degree of \par}
    \vskip 2ex%
    {\large \bf DOCTOR OF PHILOSOPHY \par}
\else
           {\large \bf \singlespacing \@title \par}
    \vskip 2ex%

    { A Thesis submitted to \par}

    { Jawaharlal Nehru Technological University Anantapur \par}
    \vskip 2ex%
    { \em For award of the degree of \par}
    \vskip 2ex%
            {\bf \large \MakeUppercase{Master Of Science}} \par
           (by Research) \par
\fi
\fi
\fi
{\bf in \par}

     {\bf \large FACULTY OF \MakeUppercase{\@department}\par\par}
     \vskip 2ex%

     {\bf \em by \par}

     {\bf \large\MakeUppercase{\@author}\par\par}

     {\bf \large [ Reg. No. \MakeUppercase{\@registerno} ]\par\par}
     \vskip 2ex%

     {\bf Under the Guidance of \par}
     \vskip 1ex%

     {\bf \large \@supervisor \@cosupervisor \par}
}
  \end{center}%


  %\centerline{\pdffig{figure=emblem.pdf}}
%  \centerline{\includegraphics{jntua.pdf}}
  \centerline{\includegraphics[scale=0.7]{JNTUA-LOGO}}
  \vspace*{-0.15in}
 {\color{navyblue}
  \begin{center}
    {\bf \normalsize RESEARCH AND DEVELOPMENT \par}
    {\bf \normalsize JAWAHARLAL NEHRU TECHNOLOGICAL UNIVERSITY ANANTAPUR \par}
    {\bf \normalsize ANANTHAPURAMU-515002}
    \vglue 0.50em
    {\bf \normalsize \@date}\par
  \end{center}
  \parskip 8pt
  }
}

\def\titlepage{\newpage\thispagestyle{empty}\c@page\z@}
\def\endtitlepage{\newpage}

%\if@Synopsis
   %\renewcommand\refname{REFERENCES}
%\else
   % QUOTATIONS
   %
   \def\quotations{\chapter*{\centerline{QUOTATIONS}}
   %\addcontentsline{toc}{chapter}{QUOTATIONS}
   }

   % DEDICATION
   %
   \def\dedication{\chapter*{\centerline{DEDICATION}}
   %\addcontentsline{toc}{chapter}{DEDICATION}
   }

   % CERTIFICATE
   %
   %   - this produces a certificate page as per JNTUA Regulations
   %     comment the following lines out to get it working.
   %
   \def\certificate{%% A preliminary chapter
     \clearpage
     \vspace*{36pt}
     \centerline{\Large \bf THESIS CERTIFICATE}
     \vskip 25pt
     \thispagestyle{empty}
     \typeout{Certificate}
     \setcounter{page}{0}
   }

   % ACKNOWLEDGEMENTS
   %
   \def\acknowledgements{\chapter*{\centerline{ACKNOWLEDGEMENTS}}
     \addcontentsline{toc}{chapter}{ACKNOWLEDGEMENTS}
   }

   % ABSTRACT
   %   - this produces pages suitable for an IITM Abstract
   \def\abstract{\chapter*{\centerline{ABSTRACT}}
   \addcontentsline{toc}{chapter}{ABSTRACT}
   }

   % PREFACE
   %
   \def\glossary{\chapter*{\centerline{PREFACE}}
   \addcontentsline{toc}{chapter}{PREFACE}
   }

   % ABBREVIATIONS
   %
   \def\abbreviations{\chapter*{\centerline{ABBREVIATIONS}}
   \addcontentsline{toc}{chapter}{ABBREVIATIONS}
   }

   % Use the nomenclature package for the LIST OF SYMBOLS section.

   % Makes the chapter heading
   \def\@makechapterhead#1{%
     {\parindent \z@ \raggedright \normalfont
       \ifnum \c@secnumdepth >\m@ne
       \begin{center}
         \Large\bfseries \@chapapp\space \thechapter
       \end{center}
       \par\nobreak
       \vskip 20\p@
       \fi
       \interlinepenalty\@M
       \Large \bf
       \begin{center}
         #1\par\nobreak
       \end{center}
       \vskip 20\p@
       \thispagestyle{empty}
     }}

   % Makes the chapter heading for \chapter* commands
   \def\@makeschapterhead#1{%
     \vspace*{25\p@}%
     {\parindent \z@ \raggedright
       \normalfont
       \interlinepenalty\@M
       \Large \bfseries #1\par\nobreak
       \vskip 20\p@
     }}


   %LIST OF PUBLICATIONS
   \def\listofpapers{
           \normalbaselines
           \chapter*{\centerline{LIST OF PUBLICATIONS}}
           \markboth{LIST OF PUBLICATIONS}{LIST OF PUBLICATIONS}
           \addcontentsline{toc}{chapter}{LIST OF PUBLICATIONS}
   }

   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   % Renewed commands to set the titles of various pages correctly.
   \renewcommand\contentsname{\centering TABLE OF CONTENTS}
   \renewcommand\listfigurename{\centering LIST OF FIGURES}
   \renewcommand\listtablename{\centering LIST OF TABLES}
   \renewcommand{\chaptername}{CHAPTER}
   \renewcommand\bibname{\centering REFERENCES}
   \renewcommand{\indexname}{\large INDEX}
   \renewcommand\appendixname{APPENDIX}
%\fi
